// pages/_app.tsx
import type { AppProps } from "next/app";
import { SessionProvider } from "next-auth/react";
import { useRouter } from "next/router";
import Navbar from "@/components/Navbar";
import Sidebar from "@/components/Sidebar";
import { SidebarProvider, useSidebar } from "@/contexts/SidebarContext";
import { LanguageProvider } from "@/contexts/LanguageContext";
import "@/styles/global.css";

function AppContent({
  Component,
  pageProps,
}: {
  Component: AppProps["Component"];
  pageProps: any;
}) {
  const router = useRouter();
  const { isCollapsed } = useSidebar();

  // Hide navbar and sidebar on login, signup, forgot password, and reset password pages
  const hideNavbar = ["/login", "/signup", "/forgot-password", "/reset-password"].includes(router.pathname);

  return (
    <>
      {!hideNavbar && (
        <>
          <Sidebar />
          <Navbar />
        </>
      )}
      <div
        className={
          !hideNavbar
            ? `pt-4 transition-all duration-300 ${
                isCollapsed ? "lg:ml-16" : "lg:ml-72"
              }`
            : ""
        }
      >
        <Component {...pageProps} />
      </div>
    </>
  );
}

export default function App({
  Component,
  pageProps: { session, ...pageProps },
}: AppProps) {
  return (
    <SessionProvider session={session}>
      <LanguageProvider>
        <SidebarProvider>
          <AppContent Component={Component} pageProps={pageProps} />
        </SidebarProvider>
      </LanguageProvider>
    </SessionProvider>
  );
}
